//  Created by Allen Ingling on Wed Mar 31 2004.
//  Copyright (c) 2004 New York University. All rights reserved.
//
//  main.m
//  ccanim
//
//


/*

	NOTES:
	
	To debug in command line mode add the command line arguments to the exectuable pane in Xcode and launch the application in the debugger from Xcode.  
	Remember to undo the command line setting  after testing !
	
*/ 

#define DEBUG_COMMAND_LINE	FALSE

#import <Cocoa/Cocoa.h>
#include <stdio.h>						//for HIPS
#include <hipl_format.h>				//for HIPS
#include "ExternHIPS.h"					//for HIPS
#import "HipsHelpers.h"					//for command line structure


/*

HIPS viewer command line flags:
	
-displaynumber			int												A number 0 to n where n-1 is the number of displays connected to the computer.  Specifies onto which display the image is presented
-displayname			string		first, middle, last					A name designating which display to use.  mutex with displaynumber. 
-palindrome				boolean											Play palendromicly 
-loop					boolean											Play continously.  Optionally accepts a number of loops.  0 stands for infinity. 
-forward				boolean											Play forwared.  Default true.  Mutex with reverse.
-reverse				boolean											Play in reverse
-exit					boolean											Exit after the animation plays.  Otherwise leave the application open
-background				string		black, white, gray, mean, edgemean
-getkeys				int												Continue to collect keypress for the specified period of seconds beyond end of the animation  
-preview				boolean											Open the movie in the preview window.  NOT YET ENABLED
-fullscreen				boolean											Open the movie in a fullscreen window.  NOT YET ENABLED
*/ 


// NOTE: We call parseargs from within main to get command line settings for relay to the Cocoa object via the commandFlags global variable.  
//We do this here and not in the Cocoa object because argc and argv are available within main amd not within the Cocoa object and are needed for parseargs().
//Alternately we could try forwarding argc and argv into the Cocla object via globals, though NSApplicationMain would have its way with them first.

//NOTE:  It obeys command line flags only if you supply a file name.
HipsViewerCommandFlagsType  commandFlags;


int main(int argc, const char *argv[])
{
	//static  Flag_Format flagfmt[] = {LASTFLAG};
	int		fileNameLength;
	char	*indexIfHv;
//	FILE	*f;
	static  Flag_Format flagfmt[] = 
	{
		//flag				mutex list						min parameters		    parameter list: type&default&name triplet, ... LASTPARAMETER
//		{"moviefile",		{LASTFLAG},						1,						{ {PTBOOLEAN, "FALSE"},  {PTSTRING, "foofilename", "movie_file"}, LASTPARAMETER }},
		{"displaynumber",   {"displayname", LASTFLAG},		1,						{ {PTBOOLEAN, "FALSE"},  {PTINT,   "0", "display-number"}, LASTPARAMETER }},         //1
		{"displayname",		{"displaynumber", LASTFLAG},	1,						{ {PTBOOLEAN, "FALSE"},  {PTSTRING,  "last", "display-name"}, LASTPARAMETER }},      //2
		{"palindrome",		{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},                                          //3
		{"loop",			{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   {PTINT,   "0", "number-of-loops"}, LASTPARAMETER }},       //4 & 5
		{"forward",			{"reverse", LASTFLAG},			0,						{ {PTBOOLEAN, "TRUE"},   LASTPARAMETER }},                                           //6
		{"reverse",			{"forward", LASTFLAG},			0,						{ {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},                                          //7
		{"exit",			{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},                                          //8
		{"exitonkey",       {LASTFLAG},                     0,                      { {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},                                          //9
		{"background",		{LASTFLAG},						1,						{ {PTBOOLEAN, "FALSE"},  {PTSTRING,  "edgemean", "color-name"}, LASTPARAMETER }},    //10
		{"getkeys",			{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   {PTINT, "0", "gather-extraduration"}, LASTPARAMETER }},    //11 & 12
		{"preview",			{LASTFLAG},						0,						{ {PTBOOLEAN, "FALSE"},   LASTPARAMETER }},                                          //13
		LASTFLAG
	};
	
//	printf("argc: %d\n", argc);
	printf("argv[0]: %s\n", argv[0]);

	

	//If launched from the finder without the degugger OS X sets argc to 2, passing a string naming the path to this executable in argv[0] (normal C Unix behavior), and in argv[0] an undocumented mystery
	// argument which causes parseargs to crash hard.  It does not do this in the debugger, so we can't look the second argument in the debugger.  If we knew what this argument was
	// and could detect it, then we could call parsargs conditionally, only when ccanim is launched from the command line, not when its launched from the finder with the evil second
	//argument, and when we don't need parsargs anyway.  So we need some way to detect within main when  ccanim is called from command line and when it is launched from the
	//finder  As hack, we copy the ccanim binary within the app bundle and rename the copy to "ccanimcl". When calling ccanim from the command line, invoke ccanimcl.  When the finder
	//launches ccanim, it invokes "ccanim".  argv[0] contains the name of this program, so we can detect how it was launched here within main by examining argv[0].  We might be able to use
	//alias for ccanim, instead of duplicating the entire file. 
	
	//detect if this is ccanim and it was launched from the finder with a mystery arg, or if its its ccanimcl and it was launched from the command line and we need to call parseargs
	commandFlags.useCommandLine=FALSE;
	if(argc>=2){
		fileNameLength=strlen(argv[0]);
		if(fileNameLength>=2){	
			indexIfHv= (char*)argv[0] + fileNameLength - 2;
			printf("%s\n",indexIfHv);
			commandFlags.useCommandLine=!strncmp("hv", indexIfHv, 2);
		}
	}
		
	//override command line detection for debugging command line mode in Xcode.  Double-click on Executables/HIPS Viewer in the Xcode Groups & Files pane and choose
	//the arguments tab from the dialog to fill in arguments passed to the application when lanched from either Xcode or the Xcode debugger.
	commandFlags.useCommandLine = DEBUG_COMMAND_LINE ? TRUE : commandFlags.useCommandLine;
		
		
	if(commandFlags.useCommandLine){
		parseargs(
			argc, argv, flagfmt, 
//				&commandFlags.useCommandLine,
//				&commandFlags.fileName,
			&commandFlags.displayNumberPresent,			//1
			&commandFlags.displayNumber,
			
			&commandFlags.displayNamePresent,			//2
			&commandFlags.displayName,
			
			&commandFlags.palindromeFlag,				//3
			
			&commandFlags.continuousFlag,				//4
			
			&commandFlags.numberOfLoops,				//5
			
			&commandFlags.forwardFlag,					//6
			
			&commandFlags.reverseFlag,					//7
			
			&commandFlags.terminateFlag,				//8
			
			&commandFlags.exitOnKeyFlag,				//9
			
			&commandFlags.backgroundPresent,			//10
			&commandFlags.backgroundColorName,
			
			&commandFlags.getKeysFlag,					//11
			
			&commandFlags.getkeysExtraDuration,			//12
			
			&commandFlags.usePreviewWindowFlag,			//13
			
			FFONE, &commandFlags.fileName
		);
	}

	return NSApplicationMain(argc, argv);
}



/*
constants for specifying command line parameter hips  from the hips_parser.h header.

#define PTBOOLEAN   0
#define PTCHAR	    1
#define PTSTRING    2
#define PTINT	    3
#define PTDOUBLE    4
#define PTFILENAME  5
#define PTLIST      6

*/


